//
//  ViewModel.swift
//

import SwiftUI
import Combine
import MyIdSDK

@objc public class ViewModel: NSObject, ObservableObject {
    
    @Published var passportData: String = ""
    @Published var dateOfBirth: String = ""
    @Published var externalId: String = ""
    @Published var residency: MyIdResidency = .resident
    @Published var environment: MyIdEnvironment = .debug
    @Published var entryType: MyIdEntryType = .identification
    @Published var locale: MyIdLocale = .uzbek
    @Published var cameraShape: MyIdCameraShape = .circle
    
    @Published var image: UIImage?
    @Published var message: String = ""
    
    @objc public func startMyId() {
        let devClientId = "your_dev_client_id"
        let devClientHash = "your_dev_client_hash"
        let devClientHashId = "your_dev_client_hash_id"
        
        let prodClientId = "your_prod_client_id"
        let prodClientHash = "your_prod_client_hash"
        let prodClientHashId = "your_prod_client_hash_id"

        let config = MyIdConfig()
        config.clientId = environment == .production ? prodClientId : devClientId
        config.clientHash = environment == .production ? prodClientHash : devClientHash
        config.clientHashId = environment == .production ? prodClientHashId : devClientHashId
        config.passportData = passportData
        config.dateOfBirth = dateOfBirth
        config.externalId = externalId
        config.residency = residency
        config.environment = environment
        config.entryType = entryType
        config.locale = locale
        config.cameraShape = cameraShape
        config.presentationStyle = .sheet
        
        MyIdClient.start(withConfig: config, withDelegate: self)
    }
}

@objc extension ViewModel: MyIdClientDelegate {
    
    public func onSuccess(result: MyIdResult) {
        message = result.code ?? ""
        image = result.image
    }
    
    public func onError(exception: MyIdException) {
        message = exception.message ?? ""
        image = nil
    }
    
    public func onUserExited() {
        message = "User exited"
        image = nil
    }
}
